*Add the sample design variables to the cross-sectional files
*Tim Goedemé, 10/07/2020


global place1 A:\Stata files\Oxfiles\EU-SILC\Cross\2020-04\
global countries1 AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IS IT LT LU LV MT NL NO PL PT RO RS SE SI SK UK

global place2 C:\Users\tgoedeme\Dropbox\Publicaties\2020\social class and poverty\StataOutput\
global exelfile Svyset_allyears1.xls

*Append d-files by year, run do-file to add sample design variables, save files by country

forvalues year=2004/2018 {
    di "********************"
	di "*     `year'     *"
	di "********************"
	clear
	foreach ctry of global countries1 { // append the files by year
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta"
		if _rc==0 {
			di "`ctry'", _continue
			append using "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta", force
			cap drop lastup
			cap drop lasttime
			
	    }
	}
	
	do "...\update 2020-07\SvysetEUSILC_`year'.do" // For further info and Stata do-files, see https://timgoedeme.com/eu-silc-standard-errors/. 
	
	foreach var of varlist _all {
		local newname = lower("`var'")
		cap rename `var' `newname'
	}
	compress

	preserve
	foreach ctry of global countries1 {
		cap confirm file "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D.dta"
		if _rc==0 {
			cap restore, preserve
			keep if country=="`ctry'"
			save "${place1}\`ctry'\\`year'\UDB_c`ctry'`year'D_sd.dta", replace
		}
	}
	restore
	
}

*


